# Зчитуємо дані
n = int(input())
c = list(map(int, input().split()))

# --- Ідея рішення ---
# Є два варіанти атаки:
# 1️⃣ Звичайна атака: приносить (r - l + 1) монет → максимум дає n монет, якщо взяти весь відрізок.
# 2️⃣ Суператака: приносить 2 * (r - l + 1) монет, але дозволена лише на підрядку, де всі елементи == 2.
# Тому потрібно знайти найдовший підрядок, який складається лише з двійок.

max_len_2 = 0
current = 0

for val in c:
    if val == 2:
        current += 1
        max_len_2 = max(max_len_2, current)
    else:
        current = 0

# Максимальна вигода:
# або звичайна атака по всьому рядку — n монет,
# або суператака на найдовшому сегменті з двійок — 2 * max_len_2 монет.
answer = max(n, 2 * max_len_2)

print(answer)
